#!/usr/bin/env python
# -*- coding: utf-8 -*-
from sqlobject import *

class ArticlesType(SQLObject):
    prefix = StringCol(alternateID=True,notNone=1)
    title = UnicodeCol(notNone=1)
    idx = StringCol(alternateID=True,notNone=1)
    articles = MultipleJoin('Articles')

class Articles(SQLObject):
    type = ForeignKey('ArticlesType',notNone=1)
    prefix = StringCol(alternateID=True,notNone=1)
    title = UnicodeCol(notNone=1)
    password = StringCol(notNone=1)
    template_set = StringCol(notNone=1)
    description = UnicodeCol(default=u'')
    keyword = UnicodeCol(default=u'')
    img = PickleCol(default=None)
    posts = MultipleJoin('Posts')

class Posts(SQLObject):
    articles = ForeignKey('Articles',notNone=1)
    slug = UnicodeCol(alternateID=True,notNone=1)
    title = UnicodeCol(default=u'')
    date = DateTimeCol(notNone=1,default=DateTimeCol.now)
    contents = PickleCol(default=None)
    rawtext = UnicodeCol(default="")
    template = StringCol(notNone=1)
    groups = ForeignKey('Groups',notNone=0)
    categories = RelatedJoin('Categories')
    label1 = UnicodeCol(default="")
    label2 = UnicodeCol(default="")
    label3 = UnicodeCol(default="")
    viewed = BoolCol(notNone=1, default=True)
    password = StringCol(notNone=1)
    updated = DateTimeCol(notNone=1,default=DateTimeCol.now)
    created = DateTimeCol(notNone=1,default=DateTimeCol.now)
    #INDEX
    articles_index = DatabaseIndex('articles')
    groups_index = DatabaseIndex('groups')
    slug_index = DatabaseIndex('slug')
    updated_index = DatabaseIndex('updated')
    date_index = DatabaseIndex('date')
    label1_index = DatabaseIndex('label1')
    label2_index = DatabaseIndex('label2')
    label3_index = DatabaseIndex('label3')
    #categories = SQLRelatedJoin(    'Categories',
    #                                intermediateTable='posts_categories',
    #                                createRelatedTable=False)

class Groups(SQLObject):
    code = StringCol(alternateID=True,notNone=1)
    parent = ForeignKey("Groups")
    label = UnicodeCol(default=u'',alternateID=True,notNone=1)
    posts = MultipleJoin('Posts')
    #INDEX
    code_index = DatabaseIndex('code')
    parent_index = DatabaseIndex('parent')

class Categories(SQLObject):
    code = StringCol(alternateID=True,notNone=1)
    parent = ForeignKey("Categories")
    label = UnicodeCol(default=u'',alternateID=True,notNone=1)
    posts = RelatedJoin('Posts')
    #INDEX
    code_index = DatabaseIndex('code')
    parent_index = DatabaseIndex('parent')
    #posts = SQLRelatedJoin(    'Posts',
    #                            intermediateTable='posts_categories',
    #                            createRelatedTable=False)

#class PostsCategories(SQLObject):
#    posts = ForeignKey('Posts', notNull=True, cascade=True)
#    categories = ForeignKey('Categories', notNull=True, cascade=True)
#    active = BoolCol(notNull=True, default=False)
#    #unique = index.DatabaseIndex(Posts, Categories, unique=True)


